/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.advancements;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.advancements.AdvancementTabType;
import net.minecraft.client.gui.screens.advancements.AdvancementWidget;
import net.minecraft.client.gui.screens.advancements.AdvancementsScreen;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class AdvancementTab {
    private final Minecraft minecraft;
    private final AdvancementsScreen screen;
    private final AdvancementTabType type;
    private final int index;
    private final AdvancementNode rootNode;
    private final DisplayInfo display;
    private final ItemStack icon;
    private final Component title;
    private final AdvancementWidget root;
    private final Map<AdvancementHolder, AdvancementWidget> widgets = Maps.newLinkedHashMap();
    private double scrollX;
    private double scrollY;
    private int minX = Integer.MAX_VALUE;
    private int minY = Integer.MAX_VALUE;
    private int maxX = Integer.MIN_VALUE;
    private int maxY = Integer.MIN_VALUE;
    private float fade;
    private boolean centered;

    public AdvancementTab(Minecraft p_97145_, AdvancementsScreen p_97146_, AdvancementTabType p_97147_, int p_97148_, AdvancementNode p_300867_, DisplayInfo p_97150_) {
        this.minecraft = p_97145_;
        this.screen = p_97146_;
        this.type = p_97147_;
        this.index = p_97148_;
        this.rootNode = p_300867_;
        this.display = p_97150_;
        this.icon = p_97150_.getIcon();
        this.title = p_97150_.getTitle();
        this.root = new AdvancementWidget(this, p_97145_, p_300867_, p_97150_);
        this.addWidget(this.root, p_300867_.holder());
    }

    public AdvancementTabType getType() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    public AdvancementNode getRootNode() {
        return this.rootNode;
    }

    public Component getTitle() {
        return this.title;
    }

    public DisplayInfo getDisplay() {
        return this.display;
    }

    public void drawTab(GuiGraphics p_282671_, int p_282721_, int p_282964_, boolean p_283052_) {
        this.type.draw(p_282671_, p_282721_, p_282964_, p_283052_, this.index);
    }

    public void drawIcon(GuiGraphics p_282895_, int p_283419_, int p_283293_) {
        this.type.drawIcon(p_282895_, p_283419_, p_283293_, this.index, this.icon);
    }

    public void drawContents(GuiGraphics p_282728_, int p_282962_, int p_281511_) {
        if (!this.centered) {
            this.scrollX = 117 - (this.maxX + this.minX) / 2;
            this.scrollY = 56 - (this.maxY + this.minY) / 2;
            this.centered = true;
        }
        p_282728_.enableScissor(p_282962_, p_281511_, p_282962_ + 234, p_281511_ + 113);
        p_282728_.pose().pushPose();
        p_282728_.pose().translate(p_282962_, p_281511_, 0.0f);
        ResourceLocation $$3 = this.display.getBackground().orElse(TextureManager.INTENTIONAL_MISSING_TEXTURE);
        int $$4 = Mth.floor(this.scrollX);
        int $$5 = Mth.floor(this.scrollY);
        int $$6 = $$4 % 16;
        int $$7 = $$5 % 16;
        for (int $$8 = -1; $$8 <= 15; ++$$8) {
            for (int $$9 = -1; $$9 <= 8; ++$$9) {
                p_282728_.blit($$3, $$6 + 16 * $$8, $$7 + 16 * $$9, 0.0f, 0.0f, 16, 16, 16, 16);
            }
        }
        this.root.drawConnectivity(p_282728_, $$4, $$5, true);
        this.root.drawConnectivity(p_282728_, $$4, $$5, false);
        this.root.draw(p_282728_, $$4, $$5);
        p_282728_.pose().popPose();
        p_282728_.disableScissor();
    }

    public void drawTooltips(GuiGraphics p_282892_, int p_283658_, int p_282602_, int p_282652_, int p_283595_) {
        p_282892_.pose().pushPose();
        p_282892_.pose().translate(0.0f, 0.0f, -200.0f);
        p_282892_.fill(0, 0, 234, 113, Mth.floor(this.fade * 255.0f) << 24);
        boolean $$5 = false;
        int $$6 = Mth.floor(this.scrollX);
        int $$7 = Mth.floor(this.scrollY);
        if (p_283658_ > 0 && p_283658_ < 234 && p_282602_ > 0 && p_282602_ < 113) {
            for (AdvancementWidget $$8 : this.widgets.values()) {
                if (!$$8.isMouseOver($$6, $$7, p_283658_, p_282602_)) continue;
                $$5 = true;
                $$8.drawHover(p_282892_, $$6, $$7, this.fade, p_282652_, p_283595_);
                break;
            }
        }
        p_282892_.pose().popPose();
        this.fade = $$5 ? Mth.clamp(this.fade + 0.02f, 0.0f, 0.3f) : Mth.clamp(this.fade - 0.04f, 0.0f, 1.0f);
    }

    public boolean isMouseOver(int p_97155_, int p_97156_, double p_97157_, double p_97158_) {
        return this.type.isMouseOver(p_97155_, p_97156_, this.index, p_97157_, p_97158_);
    }

    @Nullable
    public static AdvancementTab create(Minecraft p_97171_, AdvancementsScreen p_97172_, int p_97173_, AdvancementNode p_301072_) {
        Optional<DisplayInfo> $$4 = p_301072_.advancement().display();
        if ($$4.isEmpty()) {
            return null;
        }
        for (AdvancementTabType $$5 : AdvancementTabType.values()) {
            if (p_97173_ >= $$5.getMax()) {
                p_97173_ -= $$5.getMax();
                continue;
            }
            return new AdvancementTab(p_97171_, p_97172_, $$5, p_97173_, p_301072_, $$4.get());
        }
        return null;
    }

    public void scroll(double p_97152_, double p_97153_) {
        if (this.maxX - this.minX > 234) {
            this.scrollX = Mth.clamp(this.scrollX + p_97152_, (double)(-(this.maxX - 234)), 0.0);
        }
        if (this.maxY - this.minY > 113) {
            this.scrollY = Mth.clamp(this.scrollY + p_97153_, (double)(-(this.maxY - 113)), 0.0);
        }
    }

    public void addAdvancement(AdvancementNode p_301023_) {
        Optional<DisplayInfo> $$1 = p_301023_.advancement().display();
        if ($$1.isEmpty()) {
            return;
        }
        AdvancementWidget $$2 = new AdvancementWidget(this, this.minecraft, p_301023_, $$1.get());
        this.addWidget($$2, p_301023_.holder());
    }

    private void addWidget(AdvancementWidget p_97176_, AdvancementHolder p_301071_) {
        this.widgets.put(p_301071_, p_97176_);
        int $$2 = p_97176_.getX();
        int $$3 = $$2 + 28;
        int $$4 = p_97176_.getY();
        int $$5 = $$4 + 27;
        this.minX = Math.min(this.minX, $$2);
        this.maxX = Math.max(this.maxX, $$3);
        this.minY = Math.min(this.minY, $$4);
        this.maxY = Math.max(this.maxY, $$5);
        for (AdvancementWidget $$6 : this.widgets.values()) {
            $$6.attachToParent();
        }
    }

    @Nullable
    public AdvancementWidget getWidget(AdvancementHolder p_301219_) {
        return this.widgets.get(p_301219_);
    }

    public AdvancementsScreen getScreen() {
        return this.screen;
    }
}

